﻿var slotNum = 4;	
var language;
var rowNum;
var virtualEnableFlag;

var ctrlIpAddr = new Array(5);

function mouseOverShow(obj)
{
	if(obj.disabled == false)
	{
		obj.style.background = "url(../images/btn4_hover.png)";
	}
}
function mouseOutShow(obj)
{
	if(obj.disabled == false)
	{
		obj.style.background = "url(../images/btn4_normal.png)";
	}
}
$(document).ready(function()
{
	//用户权限，设置按钮隐藏或者显示
	var apply;
	apply = document.getElementById("applyBtn1");
	applyDispay(parent.group, apply);
	
	language = $("#language").val();
	
	document.body.style.cursor = "wait";
	window.status = "Retrieving data, please wait...";
	
	//adjustTable(slotNum);
	getNetParam();
});

var showAdvancedFlag = false;
function displayAdvancedParam()
{
	if(showAdvancedFlag == false)
	{
		$("#mapParamDiv").show();
		showAdvancedFlag = true;
		if(language == 0)
		{
			$("#advanceBtn").val("Hide Advanced Options");
		}
		else
		{
			$("#advanceBtn").val("隐藏高级选项");
		}
	}
	else
	{
		$("#mapParamDiv").hide();
		showAdvancedFlag = false;
		if(language == 0)
		{
			$("#advanceBtn").val("Show Advanced Options");
		}
		else
		{
			$("#advanceBtn").val("显示高级选项");
		}
	}
}

function MgmtPortDisplay()
{
	var xmlhttp = getHTTPObject();
	var getParams = "type=" + SUB_NET_PAGE + "&cmd=1&language=" + language + "&getIpNetwork=1";
	var response;
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	if((bd.browser != "IE") && (language == 1))
	{
		xmlhttp.overrideMimeType("text/html;charset=gb2312");
	}
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);

	xmlhttp.onreadystatechange = function()
    {
		if(xmlhttp.readyState == 4)
		{
			if((bd.browser == "IE") && (language == 1))
			{
				response = gb2utf8(xmlhttp.responseBody);
				var index = response.indexOf("</html>");
				var bias = response.length - index;
				response = response.slice(7, -bias);
			}
			else
			{
				response = xmlhttp.responseText.slice(7, -8);
			}
			var intData = 0;
			var cellCount = 0;
			var ifData = response.split("&");
			var i,id;
			var cnt = 0;
			
			for(i = 0; i < slotNum; i++)
			{
				id = i + 1;
				
				document.getElementById("privateName" + id).innerHTML = ifData[cellCount];
				
				/* Card - IP Address */	
				cellCount++;
				document.getElementById("privateIp" + id).value = ifData[cellCount];
				ctrlIpAddr[cnt++] = ifData[cellCount];
				
				/* Card - MAC Address */
				cellCount++;
				document.getElementById("privateMac" + id).innerHTML = ifData[cellCount];
				cellCount++;						
			}
			/* Card - Subnet Mask */		
			document.getElementById("privateSubnet").value = ifData[cellCount];
			
			/* Card - Default Gateway */
			cellCount++;
			document.getElementById("privateGateway").value = ifData[cellCount];
			
			document.body.style.cursor="auto";
			window.status = "Done";
		}/* End of readyState */
	}/* End of onreadystatechange */
	xmlhttp.send(getParams);
	return true;
}

function getServerMapParam()
{
	var xmlhttp = getHTTPObject();
	var getParams = "type=" + SUB_NET_PAGE + "&cmd=1&language=" + language + "&getServePortMap=1";
	var response;
	var data;
	var rowData;
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	if((bd.browser != "IE") && (language == 1))
	{
		xmlhttp.overrideMimeType("text/html;charset=gb2312");
	}
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);

	xmlhttp.onreadystatechange = function()
    {
		if(xmlhttp.readyState == 4)
		{
			if((bd.browser == "IE") && (language == 1))
			{
				response = gb2utf8(xmlhttp.responseBody);
				var index = response.indexOf("</html>");
				var bias = response.length - index;
				response = response.slice(7, -bias);
			}
			else
			{
				response = xmlhttp.responseText.slice(7, -8);
			}
			data = response.split("&");
			rowNum = data.length;
			$("#vmTable tr.data_tr").hide();
			for(var i = 0; i < rowNum; i++)
			{
				rowData = data[i].split(",");
				$("#vmTable").find("tr:eq("+(i + 2)+")").show();
				$("#index" + i).html(rowData[0]);
				$("#internalPort" + i).val(rowData[1]);
				if(rowData[1] == 23)
				{
					$("#portDescription" + i).html("TELNET");
					$("#internalPort" + i).attr("disabled", true);
				}
				else if(rowData[1] == 80)
				{
					$("#portDescription" + i).html("WEB");
					$("#internalPort" + i).attr("disabled", true);
				}
				else if(rowData[1] == 554)
				{
					$("#portDescription" + i).html("R6");
					$("#internalPort" + i).attr("disabled", true);
				}
				else
				{
					if(language == 0)
					{
						$("#portDescription" + i).html("Reserved");
					}
					else
					{
						$("#portDescription" + i).html("预留");
					}
					$("#internalPort" + i).attr("disabled", false);
				}
				$("#card1ServerPort" + i).val(rowData[2]);
				$("#card2ServerPort" + i).val(rowData[3]);
				$("#card3ServerPort" + i).val(rowData[4]);
				$("#card4ServerPort" + i).val(rowData[5]);
				$("#mapSwitch" + i).val(rowData[6]);
			}
			//enableDisableVirtualParam();
		}
	}
	xmlhttp.send(getParams);
	return true;
}

function adjustTable(slotNum)
{
	var ipTable = document.getElementById("ipTable");
	var tBody = ipTable.children[0];
	
	if(slotNum < 3)
	{
		document.getElementById("div_body").style.width = "500px";
		document.getElementById("div_tab").style.width = "480px";
		tBody.children[0].children[0].style.width = "30%";
	}
	else if(slotNum == 4)
	{
		return;
	}
	
	for(i=4,j=slotNum; i>j; i--)
	{
		for(k=0; k<3; k++)
		{
			tBody.children[k].children[i].style.display = "none";
		}
	}
	
	var per;
	switch(slotNum)
	{
		case 4:
			per = 20;
			break;
		case 3:
			per = 26;
			$("#privateSubnet").css("width", "99%");
			$("#privateGateway").css("width", "99%");
			break;
		case 2:
			per = 35;
			$("#privateSubnet").css("width", "97%");
			$("#privateGateway").css("width", "97%");
			break;
		case 1:
			per = 70;
			$("#privateSubnet").css("width", "97%");
			$("#privateGateway").css("width", "97%");
			break;
		default:
			per = 20;
			break;
	}
	for(i=1; i<=slotNum; i++)
	{
		tBody.children[0].children[i].style.width = per + "%";
	}
	$("#privateSubnet").parent().attr("colspan", slotNum);
	$("#privateGateway").parent().attr("colspan", slotNum);
}

function getSlotNum()
{
	var getParams = "type=" + SUB_NET_PAGE + "&cmd=1&getSlotNum=1";
	var xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			slotNum = parseInt(xmlhttp.responseText.slice(7, -8));
			adjustTable(slotNum);
		}
	}	
	xmlhttp.send(getParams);
	return true;
}

function refreshNetParam()
{
	getNetParam();
}

function getNetParam()
{
	DisableApply("applyBtn1");
	getSlotNum();
	MgmtPortDisplay();
	getServerMapParam();
	CardIPChangeFlag = false;
}

function getVirtualNetParam()
{
	getServerMapParam();
}

function virtualParamCheck()
{
	for(var i = 0; i < rowNum; i++)
	{
		if(!validatePort($("#internalPort" + i)))
		{
			return false;
		}
		if(!validatePort($("#card1ServerPort" + i)))
		{
			return false;
		}
		if(!validatePort($("#card2ServerPort" + i)))
		{
			return false;
		}
		if(!validatePort($("#card3ServerPort" + i)))
		{
			return false;
		}
		if(!validatePort($("#card4ServerPort" + i)))
		{
			return false;
		}
		for(var j = 0; j < 4; j++)
		{
			for(var k = j + 1; k < 4; k++)
			{
				if(parseInt($("#card" + (j + 1) + "ServerPort" + i).val(), 10) == parseInt($("#card" + (k + 1) + "ServerPort" + i).val(), 10))
				{
					if(language == 0)
				{
					alert("The value of server port conflict!");
				}
				else
				{
					alert("服务端口值冲突!");
				}
				setTimeout(function() {$("#card" + (j + 1) + "ServerPort" + i).focus()}, 50);
				$("#card" + (j + 1) + "ServerPort" + i).select();
				return false;
				}
			}
		}
	}
	return true;
}

function checkIpAddr(comp)
{
	if(Validate_IPAddress(comp.val()) == false)
	{		
		if(language == 0)
		{
			alert("Invalid IP Address. Please input a valid IP Address.");
		}
		else
		{
			alert("无效的IP地址，请输入正确的IP地址。");
		}
		setTimeout(function() {comp.focus()}, 50);
		comp.select();
		return false;
	}
	return true;
}

function validateIP(obj, num)
{
	ctrlIpAddr[num] = obj.val();
	if(num != 0)
	{
		CardIPChange();
	}
	
	if(!checkIpAddr(obj))
	{		
		return false;
	}
	return true;
}

function validateMask(obj)
{
	if(Valid_Mask(obj.val()) == false)
	{
		if(language == 0)
		{
			alert("Invalid Subnet Mask. Please input a valid Subnet Mask.");
		}
		else
		{
			alert("无效的子网掩码，请输入正确的子网掩码。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}

function validateGateway(obj)
{
	if(Validate_IP_Format(obj.val()) == false)
	{
		if(language == 0)
		{
			alert("Invalid IP Address. Please input a valid default Gateway IP Address.");
		}
		else
		{
			alert("无效的IP地址，请输入正确的默认网关IP地址。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;
}
function validatePort(obj)
{
	if(validateNumber(obj.val()) == false)
	{
		if(language == 0)
		{
			alert("Invalid number. Please enter a valid numeric value for UDP Port.");
		}
		else
		{
			alert("无效的数字，请输入一个有效的UDP端口。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	if((obj.val() < 0) || (obj.val() > 65535))
	{
		if(language == 0)
		{
			alert("Valid range for Port is 0 - 65535.");
		}
		else
		{
			alert("端口号的范围是0 - 65535。");
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	return true;  
}
	
function ValidateAllIP()
{
	var obj;
	var i,j,id;
	var ip_value;
	var mask_value;
	var gw_value;
	for(i = 0; i < slotNum; i++)
	{
		id = i + 1;
		ip_value = document.getElementById("privateIp" + id).value;		
		obj = $("#privateIp" + id);
		if(!checkIpAddr(obj))
		{
			return false;
		}				
	}
	mask_value = document.getElementById("privateSubnet").value;
	gw_value = document.getElementById("privateGateway").value;
	obj = $("#privateSubnet");
	if(validateMask(obj) == false)
	{
		return false;
	}
	if(Validate_Subnet(ip_value, mask_value) == false)
	{
		if(language == 0)
		{
			alert("Subnet Mask and IP Address do not match .Please enter a valid Subnet Mask.")
		}
		else
		{
			alert("子网掩码和IP地址不相符，请输入一个有效的子网掩码。")
		}
		setTimeout(function () {obj.focus()}, 50);
		obj.select();
		return false;
	}
	obj = $("#privateGateway");
	if(validateGateway(obj) == false)
	{
		return false;
	}
	if(gw_value != "0.0.0.0")
	{
		if(Valid_Gateway(ip_value, mask_value, gw_value) == false)
		{
			if(language == 0)
			{
				alert("Gateway and IP Address do not fall in the same network .Please enter a valid Gateway.")
			}
			else
			{
				alert("网关和IP地址没有落到同一网段，请输入一个有效的网关。")
			}
			setTimeout(function () {obj.focus()}, 50);
			obj.select();
			return false;
		}
	}
	return true;	
}

function CardIPChange()
{
	CardIPChangeFlag = true;
}

function PortConfigThroDataBase()
{
	var i,id;
	/* Generate params to POST from the from controls*/
	var params = "type=" + SUB_NET_PAGE + "&cmd=2&";	
		
	for(var i = 0; i < slotNum; i++)
	{
		id = i + 1;
	    params = params + "ip_addr_" + id + "=" + $("#privateIp" + id).val() + "&";
	}
	params = params + "subnet_mask=" + $("#privateSubnet").val() + "&default_gateway=" + $("#privateGateway").val() + "&";
	
	for(var i = 0; i < rowNum; i++)
	{
		var index = i + 1;
		params = params + "internalPort" + index + "=" + $("#internalPort" + i).val() + "&";
		params = params + "card1serverPort" + index + "=" + $("#card1ServerPort" + i).val() + "&";
		params = params + "card2serverPort" + index + "=" + $("#card2ServerPort" + i).val() + "&";
		params = params + "card3serverPort" + index + "=" + $("#card3ServerPort" + i).val() + "&";
		params = params + "card4serverPort" + index + "=" + $("#card4ServerPort" + i).val() + "&";
		if(i == rowNum - 1)
		{
			params = params + "mapSwitch" + index + "=" + $("#mapSwitch" + i).val();
		}
		else
		{
			params = params + "mapSwitch" + index + "=" + $("#mapSwitch" + i).val() + "&";
		}
	}

	var xmlhttp = getHTTPObject();
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", params.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			if(language == 0)
			{
				alert("IP network configuration updated successfully.");
			}
			else
			{
				alert("IP参数已设置成功。");
			}			
			getNetParam();
		}
	}
	xmlhttp.send(params)
	return;
}

function SetPortConfiguration()
{
	DisableApply("applyBtn1");
	document.body.style.cursor = "wait";
	window.status = "Applying settings, please wait...";
	var returnFlag;
	
	if((ValidateAllIP() == true) && (virtualParamCheck() == true))
	{
		PortConfigThroDataBase();				
	}
	else
	{
		window.status = "Done";
		document.body.style.cursor = "auto";
		EnableApply("applyBtn1");
		return false;
	}
}